package com.ejie.ab04b.service;

import com.ejie.ab04b.dao.ProyectistaDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Proyectista;

/**
 * Ab0483s00ServiceImpl generated by UDA, 16-feb-2017 9:14:37.
 * 
 * @author UDA
 */

@Service(value = "ab0483s00Service")
public class ProyectistaServiceImpl implements ProyectistaService {

	@Autowired
	private ProyectistaDao ab0483s00Dao;

	/**
	 * Inserts a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Proyectista add(Proyectista ab0483s00) {
		return this.ab0483s00Dao.add(ab0483s00);
	}

	/**
	 * Updates a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Proyectista update(Proyectista ab0483s00) {
		return this.ab0483s00Dao.update(ab0483s00);
	}

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the proyectista
	 */
	public Proyectista find(Proyectista ab0483s00) {
		return (Proyectista) this.ab0483s00Dao.find(ab0483s00);
	}

	/**
	 * Finds a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @return the list
	 */
	public List<Proyectista> findProyectistaMaxFecAlta(Proyectista ab0483s00) {
		return (List<Proyectista>) this.ab0483s00Dao
				.findProyectistaMaxFecAlta(ab0483s00);
	}

	/**
	 * Deletes a single row in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Proyectista ab0483s00) {
		this.ab0483s00Dao.remove(ab0483s00);
	}

	/**
	 * Finds a list of rows in the Ab0483s00 table.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0483s00>
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<Proyectista> findAll(Proyectista ab0483s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Proyectista>) this.ab0483s00Dao.findAll(ab0483s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0483s00 table using like.
	 * 
	 *  ab0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0483s00>
	 *
	 * @param ab0483s00 the ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<Proyectista> findAllLike(Proyectista ab0483s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Proyectista>) this.ab0483s00Dao.findAllLike(ab0483s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(Proyectista filterAb0483s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0483s00Dao.removeMultiple(filterAb0483s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0483s00>
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<Proyectista> filter(Proyectista filterAb0483s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Proyectista> listaAb0483s00 = this.ab0483s00Dao.findAllLike(
				filterAb0483s00, jqGridRequestDto, false);
		Long recordNum = this.ab0483s00Dao.findAllLikeCount(
				filterAb0483s00 != null ? filterAb0483s00 : new Proyectista(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Proyectista>> reorderSelection = this.ab0483s00Dao
					.reorderSelection(filterAb0483s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Proyectista>(jqGridRequestDto,
					recordNum, listaAb0483s00, reorderSelection);
		}
		return new JQGridResponseDto<Proyectista>(jqGridRequestDto, recordNum,
				listaAb0483s00);
	}

	/**
	 * Searches rows in the Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  searchAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0483s00>>
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param searchAb0483s00 the search ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<Proyectista>> search(Proyectista filterAb0483s00,
			Proyectista searchAb0483s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab0483s00Dao.search(filterAb0483s00, searchAb0483s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(Proyectista filterAb0483s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0483s00Dao.reorderSelection(filterAb0483s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0483s00>>
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Proyectista>> jerarquia(
			Proyectista filterAb0483s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Proyectista>> listaAb0483s00 = this.ab0483s00Dao
				.findAllLikeJerarquia(filterAb0483s00, jqGridRequestDto);
		Long recordNum = this.ab0483s00Dao.findAllLikeCountJerarquia(
				filterAb0483s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Proyectista>>(
				jqGridRequestDto, recordNum, listaAb0483s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0483s00 table.
	 * 
	 *  filterAb0483s00
	 *            Ab0483s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0483s00>>
	 *
	 * @param filterAb0483s00 the filter ab 0483 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<Proyectista>> jerarquiaChildren(
			Proyectista filterAb0483s00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Proyectista>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Proyectista>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab0483s00Dao.findAllChild(filterAb0483s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

}
